//
// $Id: cd.cc,v 1.7 2001/07/13 15:15:06 nishi Exp $
//
// Copyright (C) 2001 Shouhei Nishi.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//





#include "bochs.h"
#include "biosregs.h"
#define LOG_THIS bx_cd_bios.


bx_cd_bios_c bx_cd_bios;
#if BX_USE_CDBIOS_SMF
#define this (&bx_cd_bios)
#endif


bx_cd_bios_c::bx_cd_bios_c(void)
{
}

bx_cd_bios_c::~bx_cd_bios_c(void)
{
  // nothing for now
}


  void
bx_cd_bios_c::init(bx_bios_c *b, bx_disk_bios_c *d)
{
  BX_CD_BIOS_THIS bios = b;
  BX_CD_BIOS_THIS disk_bios = d;

  BX_CD_BIOS_THIS indisc=0;

  if (bx_options.cdromd.present) {
#ifdef LOWLEVEL_CDROM
	BX_CD_BIOS_THIS cd = new LOWLEVEL_CDROM(bx_options.cdromd.dev);
	if (bx_options.cdromd.inserted) {
	      if (BX_CD_BIOS_THIS cd->insert_cdrom()) {
		    BX_INFO(("CD BIOS: Media present in CD-ROM drive\n"));
		    BX_CD_BIOS_THIS indisc=1;
		    BX_CD_BIOS_THIS capacity = BX_CD_BIOS_THIS cd->capacity();
	      } else {		    
		    BX_INFO(("CD BIOS: Could not locate CD-ROM, continuing with media not present\n"));
	      }
	} else
#endif
	      BX_INFO(("CD BIOS: Media not present in CD-ROM drive\n"));
  } else {
    BX_INFO(("CD BIOS: Media not present in CD-ROM drive\n"));
  }
}

  void
bx_cd_bios_c::bios_exec(BX_CPU_C *cpu,
			int type,
			Bit32u addr,
			Bit32u errorno,
			Boolean isPM,
			int &exittype,
			Bit32u &exitaddr,
			Bit16u &exitseg,
			Bit64u &leasttime,
			Bit64u &maxtime)
{
  int drvno;
  Bit32u lba;
  vaddrinfo vs,vd;
  laddrinfo ls,ld;
  Bit8u buf[2048];
  int i;

  drvno = AL & 0x0f;

  BX_INFO(("CD BIOS: call %d %.8x %d:\n",type,addr,isPM));
  cpu->atexit();

  if(drvno != 0) {
    AH = 0x02;
    goto done;
  }

  if(!BX_CD_BIOS_THIS indisc) goto notready;

  switch(AH) {
  case 0x00:
    if((DX & 0x00ff) != 0x04) goto error;
    goto OK;
  case 0x01:
    DX = (DX & 0xff00) | 0x04;
    goto OK;
  case 0x03:
    goto OK;
  case 0x05:
    lba = (CX & 0xff) * 0x10000 + DX;
    for(i=0;i<BX;i++) {
#ifdef LOWLEVEL_CDROM
      if (bx_dbg.fmcdrom)
	BX_INFO(("CD BIOS: read_block 0x%.8x\n",lba+i));
      BX_CD_BIOS_THIS cd->read_block(buf,lba+i);
#endif
      if((CX >> 8) == 0x00) {
	vs.vmem=0;
	vs.a.p=buf;
	vd.vmem=1;
	vd.a.v.s=DS;
	vd.a.v.o=DI+i*2048;
	cpu->block_copy_virtual(vd,
				vs,
				cpu->sregs[BX_SEG_REG_CS].selector.rpl == 3,
				2048,
				1);
      } else if((CX >> 8) == 0xff) {
	ls.vmem=0;
	ls.a.p=buf;
	ld.vmem=1;
	ld.a.l=SI*0x10000+DI+i*2048;
	cpu->block_copy_linear(ld,
			       ls,
			       cpu->sregs[BX_SEG_REG_CS].selector.rpl == 3,
			       2048);
      } else {
	goto error;
      }
    }
    goto OK;
  case 0x0f:
    goto OK;
  case 0x53:
    AL = 0x00;
    goto OK;
  }
notready:
  CH = (CH & 0xff00) | 0x01;
error:
  AH = 0x80;
  goto done;
OK:
  AH = 0x00;
done:
  cpu->set_CF(AH != 0x00);
}
